/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;

public class OrganicCompostBlock
extends Block {
    public static IntegerProperty COMPOSTING = IntegerProperty.m_61631_((String)"composting", (int)0, (int)7);

    public OrganicCompostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)COMPOSTING, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COMPOSTING});
        super.m_7926_(builder);
    }

    public int getMaxCompostingStage() {
        return 7;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (worldIn.f_46443_) {
            return;
        }
        float chance = 0.0f;
        boolean hasWater = false;
        int maxLight = 0;
        for (BlockPos neighborPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-1, -1, -1), (BlockPos)pos.m_142082_(1, 1, 1))) {
            int light;
            BlockState neighborState = worldIn.m_8055_(neighborPos);
            if (neighborState.m_204336_(ModTags.COMPOST_ACTIVATORS)) {
                chance += 0.02f;
            }
            if (neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                hasWater = true;
            }
            if ((light = worldIn.m_45517_(LightLayer.SKY, neighborPos.m_7494_())) <= maxLight) continue;
            maxLight = light;
        }
        chance += maxLight > 12 ? 0.1f : 0.05f;
        chance += hasWater ? 0.1f : 0.0f;
        if (worldIn.m_5822_().nextFloat() <= chance) {
            if (((Integer)state.m_61143_((Property)COMPOSTING)).intValue() == this.getMaxCompostingStage()) {
                worldIn.m_7731_(pos, ((Block)ModBlocks.RICH_SOIL.get()).m_49966_(), 3);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)COMPOSTING, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)COMPOSTING) + 1)), 3);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getMaxCompostingStage() + 1 - (Integer)blockState.m_61143_((Property)COMPOSTING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        super.m_7100_(stateIn, worldIn, pos, rand);
        if (rand.nextInt(10) == 0) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123757_, (double)pos.m_123341_() + (double)rand.nextFloat(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + (double)rand.nextFloat(), 0.0, 0.0, 0.0);
        }
    }
}

